/*
 * Decompiled with CFR 0.152.
 */
package org.snomed.langauges.ecl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.snomed.langauges.ecl.ECLException;
import org.snomed.langauges.ecl.ECLObjectFactory;
import org.snomed.langauges.ecl.domain.expressionconstraint.CompoundExpressionConstraint;
import org.snomed.langauges.ecl.domain.expressionconstraint.DottedExpressionConstraint;
import org.snomed.langauges.ecl.domain.expressionconstraint.ExpressionConstraint;
import org.snomed.langauges.ecl.domain.expressionconstraint.RefinedExpressionConstraint;
import org.snomed.langauges.ecl.domain.expressionconstraint.SubExpressionConstraint;
import org.snomed.langauges.ecl.domain.refinement.EclAttribute;
import org.snomed.langauges.ecl.domain.refinement.EclAttributeGroup;
import org.snomed.langauges.ecl.domain.refinement.EclAttributeSet;
import org.snomed.langauges.ecl.domain.refinement.EclRefinement;
import org.snomed.langauges.ecl.domain.refinement.Operator;
import org.snomed.langauges.ecl.domain.refinement.SubAttributeSet;
import org.snomed.langauges.ecl.domain.refinement.SubRefinement;
import org.snomed.langauges.ecl.generated.ImpotentECLListener;
import org.snomed.langauges.ecl.generated.parser.ECLLexer;
import org.snomed.langauges.ecl.generated.parser.ECLParser;

public class ECLQueryBuilder {
    private final ECLObjectFactory eclObjectFactory;

    public ECLQueryBuilder(ECLObjectFactory eclObjectFactory) {
        this.eclObjectFactory = eclObjectFactory;
    }

    public ExpressionConstraint createQuery(String ecl) throws ECLException {
        ECLParser.ExpressionconstraintContext tree;
        ANTLRInputStream inputStream = new ANTLRInputStream(ecl);
        ECLLexer lexer = new ECLLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        ECLParser parser = new ECLParser((TokenStream)tokenStream);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            tree = parser.expressionconstraint();
        }
        catch (NullPointerException | RecognitionException | ParseCancellationException e) {
            throw new ECLException("Failed to parse ECL '" + ecl + "'", e);
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        ECLListenerImpl listener = new ECLListenerImpl(this.eclObjectFactory);
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        return listener.getRootExpressionConstraint();
    }

    private static final class ECLListenerImpl
    extends ImpotentECLListener {
        private final ECLObjectFactory eclObjectFactory;
        private ExpressionConstraint rootExpressionConstraint;

        private ECLListenerImpl(ECLObjectFactory eclObjectFactory) {
            this.eclObjectFactory = eclObjectFactory;
        }

        @Override
        public void enterExpressionconstraint(ECLParser.ExpressionconstraintContext ctx) {
            ExpressionConstraint expressionConstraint = this.build(ctx);
            if (this.rootExpressionConstraint == null) {
                this.rootExpressionConstraint = expressionConstraint;
            }
        }

        private ExpressionConstraint build(ECLParser.ExpressionconstraintContext expressionconstraint) {
            if (expressionconstraint.refinedexpressionconstraint() != null) {
                return this.build(expressionconstraint.refinedexpressionconstraint());
            }
            if (expressionconstraint.compoundexpressionconstraint() != null) {
                return this.build(expressionconstraint.compoundexpressionconstraint());
            }
            if (expressionconstraint.dottedexpressionconstraint() != null) {
                return this.build(expressionconstraint.dottedexpressionconstraint());
            }
            if (expressionconstraint.subexpressionconstraint() != null) {
                return this.build(expressionconstraint.subexpressionconstraint());
            }
            return null;
        }

        public RefinedExpressionConstraint build(ECLParser.RefinedexpressionconstraintContext ctx) {
            SubExpressionConstraint subExpressionConstraint = this.build(ctx.subexpressionconstraint());
            EclRefinement eclRefinement = this.build(ctx.eclrefinement());
            return this.eclObjectFactory.getRefinedExpressionConstraint(subExpressionConstraint, eclRefinement);
        }

        public CompoundExpressionConstraint build(ECLParser.CompoundexpressionconstraintContext ctx) {
            CompoundExpressionConstraint compoundExpressionConstraint = this.eclObjectFactory.getCompoundExpressionConstraint();
            if (ctx.conjunctionexpressionconstraint() != null) {
                compoundExpressionConstraint.setConjunctionExpressionConstraints(this.build(ctx.conjunctionexpressionconstraint().subexpressionconstraint()));
            } else if (ctx.disjunctionexpressionconstraint() != null) {
                compoundExpressionConstraint.setDisjunctionExpressionConstraints(this.build(ctx.disjunctionexpressionconstraint().subexpressionconstraint()));
            } else if (ctx.exclusionexpressionconstraint() != null) {
                compoundExpressionConstraint.setConjunctionExpressionConstraints(Collections.singletonList(this.build(ctx.exclusionexpressionconstraint().subexpressionconstraint(0))));
                compoundExpressionConstraint.setExclusionExpressionConstraint(this.build(ctx.exclusionexpressionconstraint().subexpressionconstraint(1)));
            }
            return compoundExpressionConstraint;
        }

        public DottedExpressionConstraint build(ECLParser.DottedexpressionconstraintContext ctx) {
            SubExpressionConstraint subExpressionConstraint = this.build(ctx.subexpressionconstraint());
            DottedExpressionConstraint dottedExpressionConstraint = this.eclObjectFactory.getDottedExpressionConstraint(subExpressionConstraint);
            for (ECLParser.DottedexpressionattributeContext dotCtx : ctx.dottedexpressionattribute()) {
                SubExpressionConstraint attributeSubExpressionConstraint = this.build(dotCtx.eclattributename().subexpressionconstraint());
                dottedExpressionConstraint.addDottedAttribute(attributeSubExpressionConstraint);
            }
            return dottedExpressionConstraint;
        }

        private List<SubExpressionConstraint> build(List<ECLParser.SubexpressionconstraintContext> subExpressionConstraints) {
            return subExpressionConstraints.stream().map(this::build).collect(Collectors.toList());
        }

        private SubExpressionConstraint build(ECLParser.SubexpressionconstraintContext ctx) {
            Operator operator;
            Operator operator2 = operator = ctx.constraintoperator() != null ? Operator.textLookup(ctx.constraintoperator().getText()) : null;
            if (ctx.memberof() != null) {
                operator = Operator.memberOf;
            }
            SubExpressionConstraint subExpressionConstraint = this.eclObjectFactory.getSubExpressionConstraint(operator);
            ECLParser.EclfocusconceptContext eclfocusconcept = ctx.eclfocusconcept();
            if (eclfocusconcept != null) {
                if (eclfocusconcept.wildcard() != null) {
                    subExpressionConstraint.setWildcard(true);
                }
                if (eclfocusconcept.eclconceptreference() != null) {
                    if (eclfocusconcept.eclconceptreference().term() != null) {
                        subExpressionConstraint.setTerm(eclfocusconcept.eclconceptreference().term().getText());
                    }
                    subExpressionConstraint.setConceptId(eclfocusconcept.eclconceptreference().conceptid().getText());
                }
            } else {
                subExpressionConstraint.setNestedExpressionConstraint(this.build(ctx.expressionconstraint()));
            }
            return subExpressionConstraint;
        }

        private EclRefinement build(ECLParser.EclrefinementContext ctx) {
            if (ctx == null) {
                return null;
            }
            EclRefinement refinement = this.eclObjectFactory.getRefinement();
            refinement.setSubRefinement(this.build(ctx.subrefinement()));
            if (ctx.conjunctionrefinementset() != null) {
                refinement.setConjunctionSubRefinements(this.buildSubRefinements(ctx.conjunctionrefinementset().subrefinement()));
            }
            if (ctx.disjunctionrefinementset() != null) {
                refinement.setDisjunctionSubRefinements(this.buildSubRefinements(ctx.disjunctionrefinementset().subrefinement()));
            }
            return refinement;
        }

        private List<SubRefinement> buildSubRefinements(List<ECLParser.SubrefinementContext> subrefinements) {
            return subrefinements.stream().map(this::build).collect(Collectors.toList());
        }

        private SubRefinement build(ECLParser.SubrefinementContext ctx) {
            SubRefinement subRefinement = this.eclObjectFactory.getSubRefinement();
            subRefinement.setEclAttributeSet(this.build(ctx.eclattributeset(), null));
            subRefinement.setEclAttributeGroup(this.build(ctx.eclattributegroup()));
            subRefinement.setEclRefinement(this.build(ctx.eclrefinement()));
            return subRefinement;
        }

        private EclAttributeSet build(ECLParser.EclattributesetContext ctx, EclAttributeGroup withinGroup) {
            if (ctx == null) {
                return null;
            }
            EclAttributeSet eclAttributeSet = this.eclObjectFactory.getEclAttributeSet();
            eclAttributeSet.setParentGroup(withinGroup);
            eclAttributeSet.setSubAttributeSet(this.build(ctx.subattributeset(), withinGroup));
            if (ctx.conjunctionattributeset() != null) {
                eclAttributeSet.setConjunctionAttributeSet(this.buildSubAttributeSet(ctx.conjunctionattributeset().subattributeset(), withinGroup));
            }
            if (ctx.disjunctionattributeset() != null) {
                eclAttributeSet.setDisjunctionAttributeSet(this.buildSubAttributeSet(ctx.disjunctionattributeset().subattributeset(), withinGroup));
            }
            return eclAttributeSet;
        }

        private List<SubAttributeSet> buildSubAttributeSet(List<ECLParser.SubattributesetContext> subattributeset, EclAttributeGroup withinGroup) {
            return subattributeset.stream().map(ctx -> this.build((ECLParser.SubattributesetContext)((Object)ctx), withinGroup)).collect(Collectors.toList());
        }

        private SubAttributeSet build(ECLParser.SubattributesetContext ctx, EclAttributeGroup withinGroup) {
            if (ctx == null) {
                return null;
            }
            SubAttributeSet subAttributeSet = this.eclObjectFactory.getSubAttributeSet();
            subAttributeSet.setAttribute(this.build(ctx.eclattribute(), withinGroup));
            subAttributeSet.setAttributeSet(this.build(ctx.eclattributeset(), withinGroup));
            return subAttributeSet;
        }

        private EclAttributeGroup build(ECLParser.EclattributegroupContext ctx) {
            if (ctx == null) {
                return null;
            }
            EclAttributeGroup attributeGroup = this.eclObjectFactory.getAttributeGroup();
            attributeGroup.setAttributeSet(this.build(ctx.eclattributeset(), attributeGroup));
            ECLParser.CardinalityContext cardinality = ctx.cardinality();
            if (cardinality != null) {
                if (cardinality.minvalue().nonnegativeintegervalue() != null) {
                    attributeGroup.setCardinalityMin(Integer.parseInt(cardinality.minvalue().nonnegativeintegervalue().getText()));
                }
                if (cardinality.maxvalue().nonnegativeintegervalue() != null) {
                    attributeGroup.setCardinalityMax(Integer.parseInt(cardinality.maxvalue().nonnegativeintegervalue().getText()));
                }
            }
            return attributeGroup;
        }

        private EclAttribute build(ECLParser.EclattributeContext ctx, EclAttributeGroup withinGroup) {
            ECLParser.StringcomparisonoperatorContext stringcomparisonoperator;
            ECLParser.NumericcomparisonoperatorContext numericcomparisonoperator;
            if (ctx == null) {
                return null;
            }
            EclAttribute attribute = this.eclObjectFactory.getAttribute();
            attribute.setParentGroup(withinGroup);
            ECLParser.CardinalityContext cardinality = ctx.cardinality();
            if (cardinality != null) {
                if (cardinality.minvalue().nonnegativeintegervalue() != null) {
                    attribute.setCardinalityMin(Integer.parseInt(cardinality.minvalue().nonnegativeintegervalue().getText()));
                } else {
                    attribute.setCardinalityMin(null);
                }
                if (cardinality.maxvalue().nonnegativeintegervalue() != null) {
                    attribute.setCardinalityMax(Integer.parseInt(cardinality.maxvalue().nonnegativeintegervalue().getText()));
                } else {
                    attribute.setCardinalityMax(null);
                }
            }
            if (ctx.reverseflag() != null) {
                attribute.reverse();
            }
            attribute.setAttributeName(this.build(ctx.eclattributename().subexpressionconstraint()));
            ECLParser.ExpressioncomparisonoperatorContext expressioncomparisonoperator = ctx.expressioncomparisonoperator();
            if (expressioncomparisonoperator != null) {
                attribute.setExpressionComparisonOperator(expressioncomparisonoperator.getText());
                attribute.setValue(this.build(ctx.subexpressionconstraint()));
            }
            if ((numericcomparisonoperator = ctx.numericcomparisonoperator()) != null) {
                attribute.setNumericComparisonOperator(numericcomparisonoperator.getText());
                attribute.setNumericValue(ctx.numericvalue().getText());
            }
            if ((stringcomparisonoperator = ctx.stringcomparisonoperator()) != null) {
                attribute.setStringComparisonOperator(stringcomparisonoperator.getText());
                attribute.setStringValue(ctx.stringvalue().getText());
            }
            return attribute;
        }

        ExpressionConstraint getRootExpressionConstraint() {
            return this.rootExpressionConstraint;
        }
    }
}

